/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.engine.dispatchers;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.WizePanelFatalException;
import de.wilke.wizepanel.prot.basic.Version;
import de.wilke.wizepanel.prot.data.DispatcherItemType;
import de.wilke.wizepanel.server.WpDataManager;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherActions;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherActionsV2;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherPool;
import de.wilke.wizepanel.upi.engine.transactions.Entry;
import de.wilke.wizepanel.upi.engine.transactions.TransactionManager;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DispatcherThread
extends Thread {
    private static final Logger logger = LogManager.getLogger(DispatcherThread.class);
    private final BlockingQueue<Integer> fifo = new LinkedBlockingQueue<Integer>();
    private final DispatcherItemType dispatcher;
    private volatile boolean do_run = true;
    private Status status = Status.DEAD;
    private DispatcherActions dispatcher_actions;
    private Version current_version = null;
    private static final int MAX_DEAD_COUNTER = 3;
    private int dead_counter = 0;
    private long debug_good = 0L;
    private long debug_bad = 0L;
    private boolean do_register_panels = true;
    private boolean do_update_jobs = true;
    private boolean do_update_stats = true;
    private boolean do_read_errors = true;

    public DispatcherThread(DispatcherItemType dispatcherItemType) {
        this.dispatcher = new DispatcherItemType(dispatcherItemType);
        this.update_thread_name();
        this.setStatus(Status.DEAD);
    }

    public DispatcherItemType getDispatcherData() {
        return this.dispatcher;
    }

    @Override
    public void run() {
        this.dispatcher_actions = new DispatcherActions(this.dispatcher, false, logger);
        while (this.do_run) {
            try {
                try {
                    this.fifo.take();
                    this.fifo.clear();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return;
                }
                while (this.do_run && this.single_run()) {
                }
            }
            catch (Exception exception) {
                logger.fatal("RAGNAROK", (Throwable)exception);
            }
        }
    }

    public boolean single_run() throws WizePanelExceptions {
        Object object;
        if (this.status != Status.RUNNING) {
            logger.debug("status: " + this.status.name());
        }
        if (this.status == Status.THREAD_TERMINATED) {
            block26: {
                try {
                    this.dispatcher_actions.kill_all_dispatcher_jobs();
                    this.do_run = false;
                }
                catch (WizePanelExceptions wizePanelExceptions) {
                    if (++this.dead_counter < 3) break block26;
                    this.do_run = false;
                }
            }
            return false;
        }
        List<Entry> list = TransactionManager.getManager().getAllCancelJobs(this.dispatcher.getId());
        if (list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                Entry entry = object.next();
                Entry entry2 = TransactionManager.getManager().getJob(entry.getCommandData());
                if (entry2 == null) {
                    TransactionManager.getManager().setJobStatus(entry, Entry.STATUS.ERROR);
                    continue;
                }
                if (entry2.getStatus() != Entry.STATUS.ON_SERVER.id) continue;
                TransactionManager.getManager().setJobStatus(entry2, Entry.STATUS.CANCELLED);
                TransactionManager.getManager().setJobStatus(entry, Entry.STATUS.FINISHED);
            }
        }
        if (this.status == Status.DEAD) {
            if (this.get_version()) {
                this.resetDeadCounter();
                this.setStatus(Status.RUNNING);
            } else {
                if (++this.dead_counter >= 3 && WpDataManager.getManager().getDispatcherById(this.dispatcher.getId()) == null) {
                    logger.warn("dead counter: enough");
                    DispatcherPool.getPool().removeDispatcher(this.dispatcher.getId());
                    return false;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
        }
        if ((object = this.dispatcher_actions.get_next_critical_job()) != null) {
            this.process_job((Entry)object);
            return true;
        }
        if (this.do_register_panels) {
            try {
                this.dispatcher_actions.register_panels();
                this.do_register_panels = false;
            }
            catch (WizePanelExceptions wizePanelExceptions) {
                this.setStatus(Status.DEAD);
                return true;
            }
        }
        try {
            this.do_system_jobs();
        }
        catch (WizePanelExceptions wizePanelExceptions) {
            this.setStatus(Status.DEAD);
            return true;
        }
        if (this.status == Status.WAITING) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
            if (this.dispatcher_actions.check_is_ready_to_run()) {
                this.setStatus(Status.RUNNING);
            } else {
                logger.warn("MEMORY: " + this.getDataMemory() + " vs. " + this.getCalcDataMemory());
                if (this.getDataMemory() != 0L && this.getCalcDataMemory() * 100L / this.getDataMemory() < 50L) {
                    this.dispatcher_actions.kill_all_dispatcher_jobs();
                }
                return true;
            }
        }
        if ((object = this.dispatcher_actions.get_next_job()) == null) {
            return false;
        }
        this.process_job((Entry)object);
        return true;
    }

    private void process_job(Entry entry) {
        Entry.STATUS sTATUS = null;
        DispatcherPool.getPool().update_completed_counter(entry);
        long l = 0L;
        logger.debug("action: " + entry.getId() + " " + entry.getCommandAsString() + " for WPID " + entry.getWpid());
        try {
            DispatcherActions.Reply reply = this.dispatcher_actions.exec(entry);
            sTATUS = reply.status;
            l = reply.trans_id;
            if (reply.reread_version) {
                this.setStatus(Status.DEAD);
            }
            if (reply.update_thread_name) {
                this.update_thread_name();
            }
            ++this.debug_good;
        }
        catch (BadParameters badParameters) {
            logger.error("BADer", (Throwable)((Object)badParameters));
            ++this.debug_bad;
            sTATUS = Entry.STATUS.PARAM_ERROR;
        }
        catch (WizePanelFatalException wizePanelFatalException) {
            logger.error("BADest", (Throwable)wizePanelFatalException);
            ++this.debug_bad;
            if (wizePanelFatalException.getErrorCode().doResend()) {
                sTATUS = Entry.STATUS.ON_SERVER;
                switch (wizePanelFatalException.getErrorCode()) {
                    case WP_COMM_ERROR_ID_NO_SPACE_LEFT: 
                    case WP_COMM_ERROR_ID_FATAL_FIRMWARE: {
                        this.setStatus(Status.WAITING);
                        break;
                    }
                    default: {
                        this.setStatus(Status.DEAD);
                        break;
                    }
                }
            } else {
                sTATUS = Entry.STATUS.ERROR;
                entry.setStatusDetails(wizePanelFatalException.getErrorName());
            }
        }
        catch (WizePanelExceptions wizePanelExceptions) {
            logger.error("BAD", (Throwable)wizePanelExceptions);
            ++this.debug_bad;
            sTATUS = Entry.STATUS.ON_SERVER;
            this.setStatus(Status.DEAD);
        }
        entry.increaseExecutedTransmissions();
        entry.setDispatcherTransactionId(l);
        TransactionManager.getManager().setJobStatus(entry, sTATUS);
    }

    public void wakeMeUp() {
        while (true) {
            try {
                this.fifo.put(0);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void updateJobs() {
        this.do_update_jobs = true;
        this.wakeMeUp();
    }

    public void updateStats() {
        this.do_update_stats = true;
        this.wakeMeUp();
    }

    public void readErrors() {
        this.do_read_errors = true;
        this.wakeMeUp();
    }

    public void registerPanels() {
        this.do_register_panels = true;
        this.wakeMeUp();
    }

    public String getStatus() {
        return this.status.name();
    }

    private boolean get_version() {
        this.current_version = this.dispatcher_actions.get_version();
        if (this.current_version == null) {
            return false;
        }
        this.dispatcher.params().setVersion(this.current_version.rawString());
        DispatcherItemType dispatcherItemType = WpDataManager.getManager().getDispatcherById(this.dispatcher.getId());
        if (dispatcherItemType != null) {
            dispatcherItemType.params().setVersion(this.current_version.rawString());
        }
        if (this.current_version.major() != this.dispatcher_actions.actionProtocolVersion()) {
            logger.debug("get_version[" + this.current_version.rawString() + "]: " + this.dispatcher_actions.actionProtocolVersion() + " => " + this.current_version.major());
            switch (this.current_version.major()) {
                case 2: 
                case 3: {
                    this.dispatcher_actions = new DispatcherActionsV2(this.dispatcher, this.current_version.fastModeSupported(), logger);
                    break;
                }
                default: {
                    this.dispatcher_actions = new DispatcherActions(this.dispatcher, this.current_version.fastModeSupported(), logger);
                }
            }
            try {
                this.dispatcher_actions.read_settings();
                this.dispatcher_actions.update_stats();
                this.dispatcher_actions.exec_get_errors();
            }
            catch (WizePanelExceptions wizePanelExceptions) {
                // empty catch block
            }
        }
        this.update_thread_name();
        return true;
    }

    private void update_thread_name() {
        this.setName("WP-DP-" + this.dispatcher.getId());
    }

    private void setStatus(Status status) {
        if (this.status == Status.DEAD && status == Status.RUNNING) {
            this.registerPanels();
        }
        logger.info("status: " + this.status.name() + " => " + status.name());
        this.status = status;
        this.dispatcher.params().setStatus(this.status.name());
        DispatcherItemType dispatcherItemType = WpDataManager.getManager().getDispatcherById(this.dispatcher.getId());
        if (dispatcherItemType != null) {
            dispatcherItemType.params().setStatus(this.status.name());
        }
    }

    public void terminate(boolean bl) {
        this.setStatus(Status.THREAD_TERMINATED);
        if (bl) {
            this.do_run = false;
            this.interrupt();
        }
        this.wakeMeUp();
    }

    public long getDebugGood() {
        return this.debug_good;
    }

    public long getDebugBad() {
        return this.debug_bad;
    }

    public long getCalcDataMemory() {
        return this.dispatcher_actions.calc_data_memory;
    }

    public long getDataMemory() {
        return this.dispatcher_actions.data_memory;
    }

    private void do_system_jobs() throws WizePanelExceptions {
        if (this.do_update_jobs) {
            this.dispatcher_actions.update_job_states();
            this.do_update_jobs = false;
        }
        if (this.do_update_stats) {
            this.dispatcher_actions.exec_update_stats();
            this.do_update_stats = false;
            if (this.do_read_errors) {
                this.dispatcher_actions.exec_get_errors();
                this.do_read_errors = false;
            }
        }
    }

    public void resetDeadCounter() {
        this.dead_counter = 0;
    }

    public static enum Status {
        DEAD,
        RUNNING,
        WAITING,
        THREAD_TERMINATED;

    }

    private class BadParameters
    extends WizePanelExceptions {
        private static final long serialVersionUID = 1L;

        private BadParameters() {
        }
    }
}

