/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.engine.proxy;

import de.wilke.wizepanel.core.Schadchen;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.WizePanelFatalException;
import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.core.WpGraphicsUtils;
import de.wilke.wizepanel.core.displays.Display;
import de.wilke.wizepanel.core.displays.DisplayUtils;
import de.wilke.wizepanel.core.license.LicenseManager;
import de.wilke.wizepanel.eventmanager.RulesLibrary;
import de.wilke.wizepanel.prot.comm.CommCmDispSetAudioVisualIdentify;
import de.wilke.wizepanel.prot.comm.types.SendDataHeader;
import de.wilke.wizepanel.prot.data.DispatcherItemType;
import de.wilke.wizepanel.prot.data.WizePanelItemType;
import de.wilke.wizepanel.server.Services;
import de.wilke.wizepanel.server.WpDataManager;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.templates.Template;
import de.wilke.wizepanel.upi.UpiResDescrNaming;
import de.wilke.wizepanel.upi.UpiUtils;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherPool;
import de.wilke.wizepanel.upi.engine.transactions.Entry;
import de.wilke.wizepanel.upi.engine.transactions.TransactionManager;
import de.wilke.wizepanel.upi.routing.UpiRouterItem;
import de.wilke.wizepanel.upi.routing.UpiRoutingHandler;
import de.wilke.wizepanel.upi.routing.UpiRoutingNaming;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import de.wilke.wizepanel.upi.types.RouterParameters;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WpUpiServerDataProxy {
    public static final int JSON_PRETTY_PRINTER_INDENT = 4;
    private final WpDataManager wpdata = WpDataManager.getManager();

    public String getDispatcherVersion(String string) {
        return this.getDispatcher(string).params().getVersion();
    }

    public String getDispatcherStatus(String string) {
        this.getDispatcher(string);
        return DispatcherPool.getPool().getDispatcherStatus(string);
    }

    public String dispatcherIdentify(String string, String string2) {
        this.getDispatcher(string);
        try {
            int n = Integer.parseInt(string2);
            if (!CommCmDispSetAudioVisualIdentify.isValidMode((int)n)) {
                throw new Exception("Invalid mode");
            }
        }
        catch (Exception exception) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)WizePanelExceptions.ErrorCodes.WP_SERV_INVALID_DATA.name()).type("text/plain").build());
        }
        return DispatcherPool.getPool().sendIdentify(string, string2);
    }

    public String getDispatcherJobs(String string) throws JSONException {
        this.getDispatcher(string);
        List<Entry> list = TransactionManager.getManager().getAllJobs(string);
        JSONObject jSONObject = new JSONObject();
        for (Entry entry : list) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("date", (Object)entry.getTimestamp().toString());
            jSONObject2.put("target", entry.getWpid());
            jSONObject2.put("type", (Object)entry.getCommandAsString());
            jSONObject2.put("status", (Object)entry.getStatusAsString());
            jSONObject2.put("finished", (Object)(entry.getFinishedOn() == null ? "" : entry.getFinishedOn().toString()));
            jSONObject.put(entry.getId(), (Object)jSONObject2);
        }
        return this.pretty(jSONObject);
    }

    public String getWizePanelJobs(int n) throws JSONException {
        this.getWizepanel(n);
        List<Entry> list = TransactionManager.getManager().getAllWizePanelJobs(n);
        JSONObject jSONObject = new JSONObject();
        for (Entry entry : list) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("date", (Object)entry.getTimestamp().toString());
            jSONObject2.put("router", (Object)entry.getDispatcher());
            jSONObject2.put("type", (Object)entry.getCommandAsString());
            jSONObject2.put("status", (Object)entry.getStatusAsString());
            jSONObject2.put("dptransid", entry.getDispatcherTransactionId());
            jSONObject2.put("goodta", entry.getCompletedTransactions());
            jSONObject2.put("badta", entry.getFailedFransactions());
            jSONObject2.put("dptrans", entry.getExecutedTransmissions());
            jSONObject2.put("finished", (Object)(entry.getFinishedOn() == null ? "" : entry.getFinishedOn().toString()));
            jSONObject.put(entry.getId(), (Object)jSONObject2);
        }
        return this.pretty(jSONObject);
    }

    public String getTransactionInfo(String string) throws Exception {
        Entry entry = TransactionManager.getManager().getJob(string);
        if (entry == null) {
            throw new Exception("unknown-transaction");
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("date", (Object)entry.getTimestamp().toString());
        jSONObject.put("router", (Object)entry.getDispatcher());
        jSONObject.put("type", (Object)entry.getCommandAsString());
        jSONObject.put("status", (Object)entry.getStatusAsString());
        jSONObject.put("executed-transmissions", entry.getExecutedTransmissions());
        jSONObject.put("finished", (Object)(entry.getFinishedOn() == null ? "" : entry.getFinishedOn().toString()));
        jSONObject.put("wpid", entry.getWpid());
        return this.pretty(jSONObject);
    }

    public String getDispatchers() {
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        JSONArray jSONArray = new JSONArray();
        for (UpiRouterItem upiRouterItem : upiRoutingHandler.getRouters()) {
            jSONArray.put((Object)upiRouterItem.getId());
        }
        return this.pretty(jSONArray);
    }

    public String getWizepanels(String string) {
        this.getDispatcher(string);
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        JSONArray jSONArray = new JSONArray();
        for (UpiTargetItem upiTargetItem : upiRoutingHandler.getRouterById(string).getTargets()) {
            jSONArray.put((Object)upiTargetItem.getId());
        }
        return this.pretty(jSONArray);
    }

    public String getWizepanelWakeuptime(int n) {
        return Integer.toString(this.getWizepanel(n).params().getWakeup());
    }

    public String setWizepanelWakeupTime(int n, String string) throws WizePanelExceptions {
        JSONObject jSONObject;
        int n2 = 0;
        try {
            jSONObject = new JSONObject(string);
            n2 = jSONObject.getInt(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_VALUE.toString());
        }
        catch (JSONException jSONException) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new WizePanelFatalException(WizePanelExceptions.ErrorCodes.WP_SERV_INVALID_DATA, string);
            }
        }
        if (n2 == 0 || n2 % 60 != 0) {
            throw new WizePanelFatalException(WizePanelExceptions.ErrorCodes.WP_SERV_INVALID_DATA, string);
        }
        jSONObject = this.getDispatcherByWizePanelID(n);
        UpiTargetItem upiTargetItem = WpUpiServerStaticFactory.getRoutingHandler().getTargetById(String.valueOf(n));
        if (upiTargetItem != null) {
            upiTargetItem.getParams().setRequiredWakeup(n2);
            UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
            upiRoutingHandler.saveRoutingTable();
        }
        return DispatcherPool.getPool().sendWakeUpTime(jSONObject.getId(), n, n2, true);
    }

    public String setWizepanelScreenUpdateMethod(int n, String string) throws WizePanelExceptions {
        JSONObject jSONObject;
        this.check_for_too_many_open_jobs(n);
        WizePanelItemType wizePanelItemType = this.getWizepanel(n);
        if (!wizePanelItemType.getDisplay().getType().has_display_update_method_command) {
            throw new WizePanelFatalException(WizePanelExceptions.ErrorCodes.WP_SERV_UNKNOWN_METHOD, UpiRoutingNaming.UpiRoutingTargetParams.SCREEN_UPDATE_METHOD.toString());
        }
        int n2 = 0;
        try {
            jSONObject = new JSONObject(string);
            n2 = jSONObject.getInt(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_VALUE.toString());
        }
        catch (JSONException jSONException) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new WizePanelFatalException(WizePanelExceptions.ErrorCodes.WP_SERV_INVALID_DATA, string);
            }
        }
        if (DisplayUtils.id2method((int)n2) == null) {
            throw new WizePanelFatalException(WizePanelExceptions.ErrorCodes.WP_SERV_INVALID_DATA, string);
        }
        wizePanelItemType.params().setScreenUpdateMethod(n2);
        jSONObject = WpUpiServerStaticFactory.getRoutingHandler().getTargetById(String.valueOf(n));
        jSONObject.getParams().setScreenUpdateMethod(n2);
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        upiRoutingHandler.saveRoutingTable();
        DispatcherItemType dispatcherItemType = this.getDispatcherByWizePanelID(n);
        return DispatcherPool.getPool().sendScreenUpdateMethod(dispatcherItemType.getId(), n, String.valueOf(n2));
    }

    public void setWizepanelRotation(int n, int n2) throws Exception {
        WizePanelItemType wizePanelItemType = this.getWizepanel(n);
        if (n2 < 0 || n2 > 270 || n2 % 90 != 0) {
            throw new WizePanelFatalException(WizePanelExceptions.ErrorCodes.WP_SERV_INVALID_DATA, String.valueOf(n2));
        }
        wizePanelItemType.params().setRotation(n2);
        UpiTargetItem upiTargetItem = WpUpiServerStaticFactory.getRoutingHandler().getTargetById(String.valueOf(n));
        upiTargetItem.getParams().setRotation(n2);
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        upiRoutingHandler.saveRoutingTable();
    }

    public void setWizepanelName(int n, String string) throws Exception {
        Schadchen schadchen;
        if (WpUpiServerStaticFactory.getRoutingHandler().getTargetByName(string) != null) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_SERV_DUPLICATE, string);
        }
        WizePanelItemType wizePanelItemType = this.getWizepanel(n);
        if (wizePanelItemType.params().getName().equals(string)) {
            return;
        }
        RulesLibrary rulesLibrary = RulesLibrary.getSingleton();
        if (rulesLibrary.changeField("TARGET_NAME", wizePanelItemType.params().getName(), string)) {
            rulesLibrary.save();
        }
        if ((schadchen = Services.app.eventManager().getSchadchen()).renameTarget(wizePanelItemType.params().getName(), string)) {
            schadchen.save(WpUpiServerStaticFactory.getServerLocator().getString(WpUpiServerLocator.WpUpiServerLocatorPropType.SCHADCHEN_CFG_FILE));
        }
        wizePanelItemType.params().setName(string);
        UpiTargetItem upiTargetItem = WpUpiServerStaticFactory.getRoutingHandler().getTargetById(String.valueOf(n));
        upiTargetItem.getParams().setName(string);
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        upiRoutingHandler.saveRoutingTable();
    }

    public String cancelTransaction(String string) throws Exception {
        Entry entry = TransactionManager.getManager().getJob(string);
        if (entry == null) {
            throw new Exception("unknown-transaction");
        }
        return DispatcherPool.getPool().sendCancelJob(entry.getDispatcher(), string);
    }

    public String setWizepanelImage(int n, String string) throws Exception {
        byte[] byArray;
        Object object;
        this.check_for_too_many_open_jobs(n);
        DispatcherItemType dispatcherItemType = this.getDispatcherByWizePanelID(n);
        JSONObject jSONObject = new JSONObject(string);
        String string2 = null;
        try {
            string2 = jSONObject.getString(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_DATA_TYPE.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        int n2 = 1;
        try {
            n2 = jSONObject.getInt(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_CONTENTS_COLOR_DEPTH.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        boolean bl = jSONObject.has(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_SCALE.toString());
        String string3 = null;
        try {
            string3 = jSONObject.getString(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_OVERLAY.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (string2 != null && string2.equals(UpiResDescrNaming.UpiResDescrType.TYPE_BASE64.toString())) {
            object = jSONObject.getString(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_IMAGE.toString());
            byArray = UpiUtils.base642file((String)object);
        } else {
            object = jSONObject.getString(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_IMAGE.toString());
            File file = new File((String)object);
            byArray = new byte[(int)file.length()];
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                fileInputStream.read(byArray);
            }
        }
        object = ImageIO.read(new ByteArrayInputStream(byArray));
        if (object == null) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_COMM_ERROR_ID_NO_IMAGE_FILE);
        }
        return this.send_image(n, dispatcherItemType, (BufferedImage)object, n2, string3, bl);
    }

    private String send_image(int n, DispatcherItemType dispatcherItemType, BufferedImage bufferedImage, int n2, String string, boolean bl) throws Exception {
        Serializable serializable;
        int n3;
        Graphics2D graphics2D;
        WizePanelItemType wizePanelItemType = this.getWizepanel(n);
        if (!bl && !wizePanelItemType.getDisplay().isSupportedImage(bufferedImage)) {
            LogManager.getLogger(WpUpiServerDataProxy.class).warn(WizePanelExceptions.ErrorCodes.WP_COMM_ERROR_ID_INVALID_IMAGE_SIZE.name() + ": " + wizePanelItemType.info() + " | image: " + bufferedImage.getWidth() + "x" + bufferedImage.getHeight());
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_COMM_ERROR_ID_INVALID_IMAGE_SIZE);
        }
        BufferedImage bufferedImage2 = wizePanelItemType.getDisplay().convert(bufferedImage, n2);
        LicenseManager licenseManager = LicenseManager.getManager();
        if (!licenseManager.hasValidLicense()) {
            graphics2D = (Graphics2D)bufferedImage2.getGraphics();
            n3 = Math.max(bufferedImage2.getHeight() / 10, 30);
            Font font = graphics2D.getFont().deriveFont(1);
            font = font.deriveFont((float)Math.max((double)(n3 - 5), 20.0));
            graphics2D.setFont(font);
            String string2 = "Unlicensed version!";
            serializable = graphics2D.getFontMetrics();
            int n4 = serializable.stringWidth(string2);
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), n3);
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(string2, (bufferedImage2.getWidth() - n4) / 2, n3 - 5);
            graphics2D.drawLine(0, n3 - 1, bufferedImage2.getWidth(), n3 - 1);
        }
        bufferedImage2 = wizePanelItemType.getDisplay().getType().fixedSize() ? WpGraphicsUtils.autoRotate((int)wizePanelItemType.params().getRotation(), (BufferedImage)bufferedImage2) : WpGraphicsUtils.rotate((int)wizePanelItemType.params().getRotation(), (BufferedImage)bufferedImage2);
        if (string != null && !string.isEmpty()) {
            int n5;
            graphics2D = (Graphics2D)bufferedImage2.getGraphics();
            n3 = bufferedImage2.getHeight() - 10;
            int n6 = bufferedImage2.getWidth() - 10;
            for (n5 = n3; n5 > 0; n5 -= 5) {
                serializable = new Font("Monospace", 1, n5);
                graphics2D.setFont((Font)serializable);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
                n6 = (int)rectangle2D.getWidth();
                n3 = (int)rectangle2D.getHeight();
                if (n3 < bufferedImage2.getHeight() - 10 && n6 < bufferedImage2.getWidth() - 10) break;
            }
            n5 = (bufferedImage2.getWidth() - n6) / 2;
            int n7 = (bufferedImage2.getHeight() + n3) / 2 - 20;
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(string, n5 - 10, n7 - 10);
            graphics2D.drawString(string, n5 - 10, n7 + 10);
            graphics2D.drawString(string, n5 + 10, n7 - 10);
            graphics2D.drawString(string, n5 + 10, n7 + 10);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(string, n5, n7);
        }
        if (bl && !wizePanelItemType.getDisplay().isSupportedImage(bufferedImage2)) {
            bufferedImage2 = WpGraphicsUtils.scale((BufferedImage)bufferedImage2, (int)wizePanelItemType.getDisplay().getWidth(), (int)wizePanelItemType.getDisplay().getHeight());
        }
        boolean bl2 = this.dataCommandAllowed(wizePanelItemType);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage2, bl2 ? "png" : "bmp", byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (bl2) {
            return DispatcherPool.getPool().sendData(dispatcherItemType.getId(), n, byArray, SendDataHeader.Type.IMAGE);
        }
        return DispatcherPool.getPool().sendImage(dispatcherItemType.getId(), n, byArray);
    }

    /*
     * WARNING - void declaration
     */
    public String setWizepanelTemplate(int n, String string) throws Exception {
        void var8_13;
        this.check_for_too_many_open_jobs(n);
        DispatcherItemType dispatcherItemType = this.getDispatcherByWizePanelID(n);
        JSONObject jSONObject = new JSONObject(string);
        WpFile wpFile = null;
        try {
            wpFile = new WpFile(jSONObject.getString("template"), WpFile.WpFileType.TEMPLATE_FILE);
        }
        catch (JSONException jSONException) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_SERV_INVALID_DATA, "template");
        }
        JSONObject jSONObject2 = null;
        try {
            jSONObject2 = jSONObject.getJSONObject("placeholders");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        Template template = new Template();
        if (!template.open(wpFile.getResolvedFileName())) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_SERV_INVALID_DATA, template.getLastError());
        }
        if (jSONObject2 != null && jSONObject2.length() != 0) {
            for (String string2 : JSONObject.getNames((JSONObject)jSONObject2)) {
                try {
                    template.setPlaceholder(string2, jSONObject2.getString(string2));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        Object var8_11 = null;
        try {
            String string3 = jSONObject.getString(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_OVERLAY.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        BufferedImage bufferedImage = template.exportToImage(false);
        return this.send_image(n, dispatcherItemType, bufferedImage, template.getDisplay().getColorDepth(), (String)var8_13, false);
    }

    public String setWizepanelData(int n, String string) throws Exception {
        return this.setWizepanelData(n, string, SendDataHeader.Type.UNKNOWN);
    }

    public String setWizepanelData(int n, String string, SendDataHeader.Type type) throws Exception {
        byte[] byArray;
        this.check_for_too_many_open_jobs(n);
        DispatcherItemType dispatcherItemType = this.getDispatcherByWizePanelID(n);
        JSONObject jSONObject = new JSONObject(string);
        String string2 = null;
        try {
            string2 = jSONObject.getString(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_DATA_TYPE.toString());
            type = SendDataHeader.Type.fromInt((int)jSONObject.getInt(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_CONTENTS_DATA_TYPE.toString()));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (string2 != null && string2.equals(UpiResDescrNaming.UpiResDescrType.TYPE_BASE64.toString())) {
            String string3 = jSONObject.getString(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_DATA.toString());
            byArray = UpiUtils.base642file((String)string3);
        } else {
            String string4 = jSONObject.getString(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_DATA.toString());
            File file = new File(string4);
            byArray = new byte[(int)file.length()];
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                fileInputStream.read(byArray);
            }
        }
        return DispatcherPool.getPool().sendData(dispatcherItemType.getId(), n, byArray, type);
    }

    public String getWizepanelLastseen(int n) {
        return Integer.toString(this.getWizepanel(n).getLastSeen());
    }

    public String getWizepanelBatteryUpdate(int n) {
        return Integer.toString(this.getWizepanel(n).params().getBatteryActive());
    }

    public String getWizepanelBatteryPassive(int n) {
        return Integer.toString(this.getWizepanel(n).params().getBatteryPassive());
    }

    public String getWizepanelFieldStrength(int n) {
        return Integer.toString(this.getWizepanel(n).params().getField());
    }

    public String getWizepanelSuccessfulTransactions(int n) {
        return Integer.toString(this.getWizepanel(n).params().getGoodTransmissions());
    }

    public String getWizepanelFailedTransaction(int n) {
        return Integer.toString(this.getWizepanel(n).params().getBadTransmissions());
    }

    public RouterParameters getDispatcherParams(String string) {
        DispatcherItemType dispatcherItemType = this.getDispatcher(string);
        RouterParameters routerParameters = dispatcherItemType.params();
        if (dispatcherItemType.getLastUpdate() > 0L) {
            routerParameters.setLastSeen((int)((System.currentTimeMillis() - dispatcherItemType.getLastUpdate()) / 1000L));
        } else {
            routerParameters.setLastSeen(-1);
        }
        return routerParameters;
    }

    public String getDispatcherDebug(String string) {
        this.getDispatcher(string);
        return DispatcherPool.getPool().getDispatcherDebug(string);
    }

    private WizePanelItemType getWizepanel(int n) {
        WizePanelItemType wizePanelItemType = this.wpdata.getWizepanelById(n);
        if (wizePanelItemType == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)WizePanelExceptions.ErrorCodes.WP_SERV_NO_TARGET.name()).type("text/plain").build());
        }
        return wizePanelItemType;
    }

    private DispatcherItemType getDispatcher(String string) {
        DispatcherItemType dispatcherItemType = this.wpdata.getDispatcherById(string);
        if (dispatcherItemType == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)WizePanelExceptions.ErrorCodes.WP_SERV_NO_ROUTER.name()).type("text/plain").build());
        }
        return dispatcherItemType;
    }

    private DispatcherItemType getDispatcherByWizePanelID(int n) throws WizePanelExceptions {
        DispatcherItemType dispatcherItemType = this.wpdata.getDispatcherByWizepanelId(n);
        if (dispatcherItemType == null) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_SERV_NO_ROUTER);
        }
        return dispatcherItemType;
    }

    public String setDispatcherAddress(String string, String string2) throws JSONException {
        DispatcherItemType dispatcherItemType = this.getDispatcher(string);
        JSONObject jSONObject = new JSONObject(string2);
        if (jSONObject.has(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_VALUE.toString())) {
            jSONObject = new JSONObject(jSONObject.getString(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_VALUE.toString()));
        }
        JSONObject jSONObject2 = new JSONObject(this.getDispatcherAddress(string));
        for (String string3 : JSONObject.getNames((JSONObject)jSONObject2)) {
            jSONObject.get(string3);
        }
        return DispatcherPool.getPool().setDispatcherAddress(dispatcherItemType.getId(), jSONObject.toString());
    }

    public String getDispatcherUpdateJobs(String string) {
        this.getDispatcher(string);
        DispatcherPool.getPool().sendUpdateJobs(string);
        return " ";
    }

    public String getDispatcherUpdateStats(String string) {
        this.getDispatcher(string);
        DispatcherPool.getPool().sendUpdateStats(string);
        return " ";
    }

    public String setDispatcherFirmware(String string, String string2) throws WizePanelExceptions {
        try {
            JSONObject jSONObject = new JSONObject(string2);
            string2 = jSONObject.getString(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_DATA.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (string2 == null) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_SERV_INVALID_DATA);
        }
        return DispatcherPool.getPool().sendDispatcherUpdate(string, string2);
    }

    public String setDispatcherTimeZone(String string, String string2) {
        UpiRouterItem upiRouterItem;
        DispatcherItemType dispatcherItemType = this.getDispatcher(string);
        if (dispatcherItemType != null) {
            dispatcherItemType.params().setTimeZone(string2);
        }
        if ((upiRouterItem = WpUpiServerStaticFactory.getRoutingHandler().getRouterById(string)) != null) {
            upiRouterItem.getParams().setTimeZone(string2);
            UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
            upiRoutingHandler.saveRoutingTable();
        }
        return "";
    }

    public String setDispatcherName(String string, String string2) {
        UpiRoutingHandler upiRoutingHandler;
        UpiRouterItem upiRouterItem;
        DispatcherItemType dispatcherItemType = this.getDispatcher(string);
        if (dispatcherItemType != null) {
            dispatcherItemType.params().setName(string2);
        }
        if ((upiRouterItem = (upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler()).getRouterById(string)) != null) {
            upiRouterItem.getParams().setName(string2);
            upiRoutingHandler.saveRoutingTable();
        }
        DispatcherPool.getPool().updateDispatcherName(string, string2);
        return "";
    }

    public String restartDispatcher(String string) {
        this.getDispatcher(string);
        return DispatcherPool.getPool().sendReset(string);
    }

    public String getDispatcherAddress(String string) throws JSONException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_IP.toString());
        hashSet.add(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_PORT.toString());
        hashSet.add(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_SUBNET.toString());
        hashSet.add(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_GATEWAY.toString());
        DispatcherItemType dispatcherItemType = this.getDispatcher(string);
        JSONObject jSONObject = dispatcherItemType.params().toJSON();
        for (String string2 : JSONObject.getNames((JSONObject)jSONObject)) {
            if (hashSet.contains(string2)) continue;
            jSONObject.remove(string2);
        }
        return this.pretty(jSONObject);
    }

    private String pretty(JSONArray jSONArray) {
        try {
            return jSONArray.toString(4);
        }
        catch (JSONException jSONException) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jSONException.getMessage()).type("text/plain").build());
        }
    }

    private String pretty(JSONObject jSONObject) {
        try {
            return jSONObject.toString(4);
        }
        catch (JSONException jSONException) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jSONException.getMessage()).type("text/plain").build());
        }
    }

    public String getWizepanelParams(int n) {
        try {
            return this.pretty(this.get_wp_params(n));
        }
        catch (JSONException jSONException) {
            return "";
        }
    }

    public String getWizepanelParam(int n, String string) {
        try {
            JSONObject jSONObject = this.get_wp_params(n);
            if (jSONObject.has(string)) {
                return jSONObject.getString(string);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    private JSONObject get_wp_params(int n) throws JSONException {
        WizePanelItemType wizePanelItemType = this.getWizepanel(n);
        return wizePanelItemType.params().toJSON();
    }

    public String getSystemRouting() {
        try {
            return this.pretty(WpDataManager.getManager().toJSON());
        }
        catch (JSONException jSONException) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)WizePanelExceptions.ErrorCodes.WP_SERV_NO_ROUTING_DESCRIPTION.name()).type("text/plain").build());
        }
    }

    public String getSystemRoutingChanged(String string) throws NoSuchAlgorithmException, JSONException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = messageDigest.digest(this.getSystemRouting().getBytes("UTF-8"));
        BigInteger bigInteger = new BigInteger(1, byArray);
        Object object = bigInteger.toString(16);
        if (((String)object).length() % 2 != 0) {
            object = "0" + (String)object;
        }
        if (null == string || string.isEmpty()) {
            return object;
        }
        if (((String)object).equals(string)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_MODIFIED).build());
        }
        return object;
    }

    private void check_for_too_many_open_jobs(int n) throws WizePanelExceptions {
        int n2 = WpUpiServerStaticFactory.getServerLocator().getInt(WpUpiServerLocator.WpUpiServerLocatorPropType.WP_SERVER_MAX_OPEN_JOBS);
        int n3 = TransactionManager.getManager().getAllOpenWizePanelJobs(n);
        if (n3 >= n2) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_SERV_TOO_MANY_OPEN_JOBS);
        }
    }

    private boolean dataCommandAllowed(WizePanelItemType wizePanelItemType) {
        return wizePanelItemType.isEPaper() || wizePanelItemType.getDisplay().getType() == Display.Type.TYPE_CUSTOM;
    }
}

