/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.engine.transactions;

import de.wilke.wizepanel.core.Counter;
import de.wilke.wizepanel.prot.data.WizePanelItemType;
import de.wilke.wizepanel.server.WpDataManager;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.upi.UpiUtils;
import de.wilke.wizepanel.upi.engine.dispatchers.DataCommand;
import de.wilke.wizepanel.upi.engine.transactions.Entry;
import de.wilke.wizepanel.upi.engine.transactions.FinalImage;
import de.wilke.wizepanel.upi.engine.transactions.HibernateUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.json.JSONException;
import org.json.JSONObject;

public class TransactionManager {
    private static Logger m_logger = LogManager.getLogger(TransactionManager.class);
    public static final String ERR_UNKNOWN_ID = "unknown-transaction";
    private static Throwable m_err_msg = null;
    private static TransactionManager m_instance = new TransactionManager(HibernateUtil.getConnectionURL());

    private TransactionManager(String string) {
        try {
            m_logger.info("Database: " + string);
            if (string == null) {
                throw new Throwable("database-connection-url-is-null");
            }
            Connection connection = DriverManager.getConnection(string, "SA", "");
            Statement statement = connection.createStatement();
            statement.execute("SET WRITE_DELAY 0 MILLIS");
        }
        catch (Throwable throwable) {
            m_err_msg = throwable;
        }
    }

    public static TransactionManager getManager() {
        return m_instance;
    }

    public static String getErrorMessage() {
        if (m_err_msg == null) {
            return null;
        }
        return m_err_msg.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String add(Entry.COMMAND cOMMAND, int n, String string, int n2, String string2, Entry.STATUS sTATUS, int n3, int n4) {
        Entry entry = null;
        try (Session session = null;){
            session = HibernateUtil.getSessionFactory().openSession();
            session.beginTransaction();
            this.merge(session, cOMMAND, string, n2);
            entry = new Entry(cOMMAND.id, n, string, n2, string2, sTATUS, n3, n4);
            entry.setCommandId(cOMMAND.id);
            session.save((Object)entry);
            session.getTransaction().commit();
        }
        m_logger.debug("new job: " + cOMMAND.name() + " priority: " + n + " dispatcher: " + string + " wpid: " + n2 + " => " + entry.getId());
        return entry.getId();
    }

    private void check_jvm_memory() {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().maxMemory();
        long l3 = Runtime.getRuntime().freeMemory();
        m_logger.debug("HEAP: total:" + l + " max:" + l2 + " free:" + l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Entry> select(String object, Map<String, Object> map, int n) {
        Session session = HibernateUtil.getSessionFactory().openSession();
        session.beginTransaction();
        try {
            Object object2;
            Object object3;
            object = object == null || ((String)object).trim().length() == 0 ? "" : "WHERE " + (String)object;
            Query query = session.createQuery("FROM Entry AS m " + (String)object + " ORDER BY m.priority ASC, m.timestamp ASC");
            if (map != null && map.size() != 0) {
                object3 = map.keySet().iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    query.setParameter((String)object2, map.get(object2));
                }
            }
            if (n > 0) {
                query.setMaxResults(n);
            }
            object2 = object3 = query.list();
            return object2;
        }
        finally {
            session.getTransaction().commit();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int count(String object, Map<String, Object> map, Session session) {
        Session session2 = session;
        if (session2 == null) {
            session2 = HibernateUtil.getSessionFactory().openSession();
            session2.beginTransaction();
        }
        try {
            object = object == null || ((String)object).trim().length() == 0 ? "" : " WHERE " + (String)object;
            Query query = session2.createQuery("SELECT COUNT(*) FROM Entry AS m" + (String)object);
            if (map != null && map.size() != 0) {
                for (String string : map.keySet()) {
                    query.setParameter(string, map.get(string));
                }
            }
            Iterator<String> iterator = query.uniqueResult();
            int n = ((Number)((Object)iterator)).intValue();
            return n;
        }
        finally {
            if (session == null) {
                session2.getTransaction().commit();
                session2.close();
            }
        }
    }

    public Entry getNextUnfinishedJob(int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("wpid", n);
        hashMap.put("status1", Entry.STATUS.ON_ROUTER.id);
        hashMap.put("status2", Entry.STATUS.ON_SERVER.id);
        List<Entry> list = this.select("WIZEPANEL=:wpid AND (STATUS=:status1 OR STATUS=:status2)", hashMap, 1);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<Entry> getAllJobs(String string, Entry.STATUS sTATUS) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dispatcher", string);
        hashMap.put("status", sTATUS.id);
        return this.select("dispatcher=:dispatcher AND status=:status", hashMap, 0);
    }

    public List<Entry> getAllJobs(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dispatcher", string);
        return this.select("DISPATCHER=:dispatcher", hashMap, 0);
    }

    public List<Entry> getAllCancelJobs(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dispatcher", string);
        hashMap.put("status", Entry.STATUS.ON_SERVER.id);
        hashMap.put("command", Entry.COMMAND.CANCEL_TRANSACTION.id);
        return this.select("dispatcher=:dispatcher AND status=:status AND command_id = :command", hashMap, 0);
    }

    public List<Entry> getAllWizePanelJobs(int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("wpid", n);
        return this.select("wizepanel=:wpid", hashMap, 0);
    }

    public int getAllOpenWizePanelJobs(int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("wpid", n);
        hashMap.put("status1", Entry.STATUS.ON_SERVER.id);
        hashMap.put("status2", Entry.STATUS.ON_ROUTER.id);
        return this.count("wizepanel=:wpid AND (status=:status1 OR status=:status2)", hashMap, null);
    }

    public Entry getJob(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", string);
        List<Entry> list = this.select("id=:id", hashMap, 1);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public void setJobStatus(Entry entry, Entry.STATUS sTATUS) {
        Object object;
        String string;
        if (sTATUS == Entry.STATUS.ON_TARGET && FinalImage.isOkay() && (entry.getCommand() == Entry.COMMAND.WP_IMAGE || entry.getCommand() == Entry.COMMAND.WP_DATA)) {
            string = FinalImage.createPath(entry.getWpid());
            m_logger.debug("Saving image to " + string);
            try {
                object = new FileOutputStream(string);
                try {
                    if (entry.getCommand() == Entry.COMMAND.WP_IMAGE) {
                        ((FileOutputStream)object).write(UpiUtils.base642data((String)entry.getCommandData()));
                    } else {
                        DataCommand dataCommand = new DataCommand(entry.getCommandData());
                        ((FileOutputStream)object).write(dataCommand.bytes());
                    }
                }
                finally {
                    ((FileOutputStream)object).close();
                }
            }
            catch (Exception exception) {
                m_logger.warn("Could not save image: " + exception.getMessage());
            }
        }
        string = entry.getStatusAsString();
        object = HibernateUtil.getSessionFactory().openSession();
        object.beginTransaction();
        entry.setStatus(sTATUS.id);
        if (sTATUS.is_final) {
            entry.setCommandData("");
            entry.setFinishedOn(new Timestamp(System.currentTimeMillis()));
        }
        object.update((Object)entry);
        object.getTransaction().commit();
        object.close();
        m_logger.debug("job status: [" + entry.toString() + "] from " + string);
    }

    public void cleanup() {
        m_logger.debug("Cleanup");
        this.check_jvm_memory();
        this.cleanup_images();
        this.cleanup_database();
    }

    private void cleanup_images() {
        if (!FinalImage.isOkay()) {
            return;
        }
        if (WpDataManager.getManager().getWizepanels().isEmpty()) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (WizePanelItemType wizePanelItemType : WpDataManager.getManager().getWizepanels()) {
            hashSet.add(FinalImage.createPath(wizePanelItemType.getSerialNo()));
        }
        long l = System.currentTimeMillis() - 2592000000L;
        for (File file : FinalImage.listFiles()) {
            if (!file.getName().endsWith(".png") || hashSet.contains(file.getName()) || file.lastModified() >= l) continue;
            m_logger.debug("Removing final image: " + file.getName() + " [" + (file.delete() ? "ok" : "no") + "]");
        }
    }

    private void cleanup_database() {
        Session session = HibernateUtil.getSessionFactory().openSession();
        session.beginTransaction();
        int n = WpUpiServerStaticFactory.getServerLocator().getInt(WpUpiServerLocator.WpUpiServerLocatorPropType.UPI_WP_SERVER_COMMANDS_CLEANUP_AFTER_HOURS);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis() - (long)(3600000 * n));
        Query query = session.createQuery("DELETE FROM Entry  WHERE status <> :status1 AND status <> :status2 AND timestamp < :deadline");
        query.setParameter("status1", (Object)Entry.STATUS.ON_SERVER.id);
        query.setParameter("status2", (Object)Entry.STATUS.ON_ROUTER.id);
        query.setTimestamp("deadline", (Date)timestamp);
        int n2 = query.executeUpdate();
        Timestamp timestamp2 = new Timestamp(System.currentTimeMillis() - (long)(3600000 * n * 12));
        Query query2 = session.createQuery("DELETE FROM Entry  WHERE timestamp < :deadline");
        query2.setTimestamp("deadline", (Date)timestamp2);
        int n3 = query2.executeUpdate();
        m_logger.debug("DELETED: " + n2 + " " + n3 + " -- REMAINING: " + this.count(null, null, session));
        session.getTransaction().commit();
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump_to_file(String string) {
        Session session = HibernateUtil.getSessionFactory().openSession();
        session.beginTransaction();
        try (PrintWriter printWriter = new PrintWriter(string);){
            Query query = session.createQuery("FROM Entry AS m");
            Iterator iterator = query.iterate();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                entry.getEverything(printWriter);
                printWriter.println();
            }
        }
        catch (Exception exception) {
            m_logger.error((Object)exception);
        }
        finally {
            session.getTransaction().commit();
            session.close();
        }
    }

    public void merge(Session session, Entry.COMMAND cOMMAND, String string, int n) {
        if (!cOMMAND.is_mergeable || !WpUpiServerStaticFactory.getServerLocator().getBoolean(WpUpiServerLocator.WpUpiServerLocatorPropType.UPI_WP_SERVER_MERGE_COMMANDS)) {
            return;
        }
        Query query = session.createQuery("UPDATE Entry  SET status = :newstatus, command_data = :newcommand_data WHERE command_id = :command_id" + (cOMMAND.is_dispatcher_command ? " AND dispatcher = :dispatcher" : "") + " AND wpid = :wpid AND (status = :status1 OR status = :status2)");
        query.setParameter("newstatus", (Object)Entry.STATUS.OVERWRITTEN.id);
        query.setParameter("newcommand_data", (Object)"");
        query.setParameter("command_id", (Object)cOMMAND.id);
        if (cOMMAND.is_dispatcher_command) {
            query.setParameter("dispatcher", (Object)string);
        }
        query.setParameter("wpid", (Object)n);
        query.setParameter("status1", (Object)Entry.STATUS.ON_SERVER.id);
        query.setParameter("status2", (Object)Entry.STATUS.ON_ROUTER.id);
        int n2 = query.executeUpdate();
        if (n2 != 0) {
            m_logger.debug("MERGED(" + cOMMAND.name() + "): " + n2 + " rows.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String db_stats() {
        Query query;
        Session session = HibernateUtil.getSessionFactory().openSession();
        session.beginTransaction();
        HashMap<CallSite, Counter> hashMap = new HashMap<CallSite, Counter>();
        for (Entry.STATUS enum_ : Entry.STATUS.values()) {
            hashMap.put((CallSite)((Object)("status." + enum_.name())), new Counter());
        }
        for (Enum enum_ : Entry.COMMAND.values()) {
            hashMap.put((CallSite)((Object)("command." + enum_.name())), new Counter());
        }
        try {
            query = session.createQuery("FROM Entry AS m");
            Iterator iterator = query.iterate();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                ((Counter)hashMap.get("status." + entry.getStatusAsString())).inc();
                ((Counter)hashMap.get("command." + entry.getCommandAsString())).inc();
                if (entry.getWpid() != 0) {
                    if (!hashMap.containsKey("wp." + entry.getWpid())) {
                        hashMap.put((CallSite)((Object)("wp." + entry.getWpid())), new Counter());
                    }
                    ((Counter)hashMap.get("wp." + entry.getWpid())).inc();
                }
                if (!hashMap.containsKey("dp." + entry.getDispatcher())) {
                    hashMap.put((CallSite)((Object)("dp." + entry.getDispatcher())), new Counter());
                }
                ((Counter)hashMap.get("dp." + entry.getDispatcher())).inc();
            }
        }
        catch (Exception exception) {
            m_logger.error((Object)exception);
        }
        finally {
            session.getTransaction().commit();
            session.close();
        }
        try {
            query = new JSONObject(hashMap);
            return query.toString(4);
        }
        catch (JSONException jSONException) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reassignDispatcherJobs(String string, String string2) {
        try (Session session = null;){
            session = HibernateUtil.getSessionFactory().openSession();
            session.beginTransaction();
            Query query = session.createQuery("UPDATE Entry  SET dispatcher = :newid WHERE dispatcher = :oldid");
            query.setParameter("newid", (Object)string2);
            query.setParameter("oldid", (Object)string);
            int n = query.executeUpdate();
            m_logger.debug("REASSIGNED dispatcher(" + string + "=>" + string2 + "): " + n + " rows.");
            session.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reassignWizePanelJobs(int n, String string) {
        try (Session session = null;){
            session = HibernateUtil.getSessionFactory().openSession();
            session.beginTransaction();
            Query query = session.createQuery("UPDATE Entry  SET dispatcher = :newid WHERE wizepanel = :wpid AND (status = :status1 OR status = :status2)");
            query.setParameter("newid", (Object)string);
            query.setParameter("wpid", (Object)n);
            query.setParameter("status1", (Object)Entry.STATUS.ON_SERVER.id);
            query.setParameter("status2", (Object)Entry.STATUS.ON_ROUTER.id);
            int n2 = query.executeUpdate();
            m_logger.debug("REASSIGNED panel jobs(" + n + "=>" + string + "): " + n2 + " rows.");
            session.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWizePanelJobs(int n) {
        try (Session session = null;){
            session = HibernateUtil.getSessionFactory().openSession();
            session.beginTransaction();
            Query query = session.createQuery("DELETE FROM Entry  WHERE wizepanel = :wpid");
            query.setParameter("wpid", (Object)n);
            int n2 = query.executeUpdate();
            m_logger.debug("DELETING panel jobs(" + n + "): " + n2 + " rows.");
            session.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abandonAllOpenWizePanelJobs() {
        try (Session session = null;){
            session = HibernateUtil.getSessionFactory().openSession();
            session.beginTransaction();
            Query query = session.createQuery("UPDATE Entry  SET dispatcher = :newid WHERE wizepanel <> 0 AND (status = :status1 OR status = :status2)");
            query.setParameter("newid", (Object)"");
            query.setParameter("status1", (Object)Entry.STATUS.ON_SERVER.id);
            query.setParameter("status2", (Object)Entry.STATUS.ON_ROUTER.id);
            int n = query.executeUpdate();
            m_logger.debug("ABANDONED all WizePanel jobs: " + n + " rows.");
            session.getTransaction().commit();
        }
    }
}

