/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import org.simpleframework.http.core.ContainerEvent;
import org.simpleframework.http.core.Selector;
import org.simpleframework.http.core.Timer;
import org.simpleframework.http.message.Body;
import org.simpleframework.http.message.Entity;
import org.simpleframework.http.message.EntityConsumer;
import org.simpleframework.http.message.Header;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.Cursor;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.trace.Trace;
import org.simpleframework.util.buffer.Allocator;

class Collector
implements Entity {
    private final EntityConsumer entity;
    private final Channel channel;
    private final Cursor cursor;
    private final Trace trace;
    private final Timer timer;

    public Collector(Allocator allocator, Channel channel) {
        this.entity = new EntityConsumer(allocator, channel);
        this.timer = new Timer(TimeUnit.MILLISECONDS);
        this.cursor = channel.getCursor();
        this.trace = channel.getTrace();
        this.channel = channel;
    }

    public void collect(Selector selector) throws IOException {
        while (this.cursor.isReady() && !this.entity.isFinished()) {
            this.timer.set();
            this.entity.consume(this.cursor);
        }
        if (this.cursor.isOpen()) {
            if (this.entity.isFinished()) {
                this.trace.trace((Object)ContainerEvent.REQUEST_READY);
                selector.ready(this);
            } else {
                this.trace.trace((Object)TransportEvent.READ_WAIT);
                selector.select(this);
            }
        }
    }

    public long getTime() {
        return this.timer.get();
    }

    public Header getHeader() {
        return this.entity.getHeader();
    }

    public Body getBody() {
        return this.entity.getBody();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public SocketChannel getSocket() {
        return this.channel.getSocket();
    }
}

