/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;
import org.simpleframework.transport.BufferRecycler;
import org.simpleframework.transport.Packet;
import org.simpleframework.transport.PacketException;

class BufferAdapter
implements Packet {
    private BufferRecycler recycler;
    private ByteBuffer buffer;
    private long sequence;
    private boolean closed;

    public BufferAdapter(ByteBuffer buffer, long sequence) {
        this(buffer, null, sequence);
    }

    public BufferAdapter(ByteBuffer buffer, BufferRecycler recycler, long sequence) {
        this.sequence = sequence;
        this.recycler = recycler;
        this.buffer = buffer;
    }

    public long sequence() {
        return this.sequence;
    }

    public int space() {
        if (this.closed) {
            return 0;
        }
        return this.buffer.remaining();
    }

    public int capacity() {
        if (this.closed) {
            return 0;
        }
        return this.buffer.capacity();
    }

    public int length() {
        if (this.closed) {
            return 0;
        }
        return this.capacity() - this.space();
    }

    public int compareTo(Packet packet) {
        long other = packet.sequence();
        if (other > this.sequence) {
            return -1;
        }
        if (this.sequence > other) {
            return 1;
        }
        return 0;
    }

    public Packet extract() throws IOException {
        return this;
    }

    public String encode() throws IOException {
        return this.encode("UTF-8");
    }

    public String encode(String encoding) throws IOException {
        ByteBuffer segment = this.buffer.duplicate();
        if (segment != null) {
            segment.flip();
        }
        return this.encode(encoding, segment);
    }

    private String encode(String encoding, ByteBuffer segment) throws IOException {
        Charset charset = Charset.forName(encoding);
        CharBuffer text = charset.decode(segment);
        return text.toString();
    }

    public int append(ByteBuffer data) throws IOException {
        int space;
        int require = data.remaining();
        if (require > (space = this.space())) {
            require = space;
        }
        return this.append(data, require);
    }

    public int append(ByteBuffer data, int count) throws IOException {
        ByteBuffer segment = data.slice();
        if (this.closed) {
            throw new PacketException("Packet has been closed");
        }
        int mark = data.position();
        int size = mark + count;
        if (count > 0) {
            data.position(size);
            segment.limit(count);
            this.buffer.put(segment);
        }
        return count;
    }

    public int write(ByteChannel channel) throws IOException {
        int size = this.length();
        if (size <= 0) {
            return 0;
        }
        return this.write(channel, size);
    }

    public int write(ByteChannel channel, int count) throws IOException {
        if (this.closed) {
            throw new PacketException("Packet has been closed");
        }
        if (count <= 0) {
            return 0;
        }
        this.buffer.flip();
        return this.write(channel, this.buffer);
    }

    private int write(ByteChannel channel, ByteBuffer segment) throws IOException {
        int count;
        int size;
        int require = segment.remaining();
        for (count = 0; count < require && (size = channel.write(segment)) > 0; count += size) {
        }
        if (count >= 0) {
            segment.compact();
        }
        return count;
    }

    public void close() {
        if (this.recycler != null) {
            this.recycler.recycle(this.buffer);
        }
        this.recycler = null;
        this.closed = true;
    }

    public boolean isReference() {
        return false;
    }

    public String toString() {
        return String.format("%s %s", this.sequence, this.buffer);
    }
}

