/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.simpleframework.transport.PacketFlusher;
import org.simpleframework.transport.PacketWriter;
import org.simpleframework.transport.Scheduler;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.TransportException;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.reactor.Reactor;
import org.simpleframework.transport.trace.Trace;

class SocketFlusher
implements PacketFlusher {
    private PacketWriter writer;
    private Signaller signaller;
    private Scheduler scheduler;
    private Trace trace;
    private boolean closed;

    public SocketFlusher(Socket socket, Reactor reactor, PacketWriter writer) throws IOException {
        this.signaller = new Signaller(writer);
        this.scheduler = new Scheduler(socket, reactor, this.signaller, this);
        this.trace = socket.getTrace();
        this.writer = writer;
    }

    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new TransportException("Flusher is closed");
        }
        boolean block = this.writer.isBlocking();
        if (!this.closed) {
            this.scheduler.schedule(block);
        }
    }

    private synchronized void execute() throws IOException {
        boolean ready = this.writer.flush();
        if (!ready) {
            boolean block = this.writer.isBlocking();
            if (!block && !this.closed) {
                this.scheduler.release();
            }
            this.scheduler.repeat();
        } else {
            this.scheduler.ready();
        }
    }

    private synchronized void abort() throws IOException {
        this.scheduler.close();
        this.writer.close();
    }

    public synchronized void close() throws IOException {
        boolean ready = this.writer.flush();
        if (!this.closed) {
            this.closed = true;
        }
        if (!ready) {
            this.scheduler.schedule(true);
        }
    }

    private class Signaller
    implements Operation {
        private final PacketWriter writer;

        public Signaller(PacketWriter writer) {
            this.writer = writer;
        }

        public SocketChannel getChannel() {
            return this.writer.getChannel();
        }

        public void run() {
            try {
                SocketFlusher.this.execute();
            }
            catch (Exception cause) {
                SocketFlusher.this.trace.trace((Object)TransportEvent.ERROR, cause);
                this.cancel();
            }
        }

        public void cancel() {
            try {
                SocketFlusher.this.abort();
            }
            catch (Exception cause) {
                SocketFlusher.this.trace.trace((Object)TransportEvent.ERROR, cause);
            }
        }
    }
}

