/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.restlet.ext.jaxrs.internal.util.EncodeOrCheck;

class MatchedInfo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final List<Object> resources;
    private volatile List<String> urisDecoded;
    private final List<String> urisEncoded;

    public MatchedInfo(List<String> urisEncoded, List<Object> resources) {
        this.urisEncoded = Arrays.asList(urisEncoded.toArray(EMPTY_STRING_ARRAY));
        this.resources = Arrays.asList(resources.toArray());
    }

    List<Object> getResources() {
        return this.resources;
    }

    List<String> getUris(boolean decode) {
        if (decode) {
            if (this.urisDecoded == null) {
                ArrayList<String> urisDecoded = new ArrayList<String>(this.urisEncoded.size());
                for (String uriEncoded : this.urisEncoded) {
                    urisDecoded.add(EncodeOrCheck.all(uriEncoded, false));
                }
                this.urisDecoded = Collections.unmodifiableList(urisDecoded);
            }
            return this.urisDecoded;
        }
        return this.urisEncoded;
    }
}

