/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.StreamBridge;
import it.sauronsoftware.cron4j.Task;
import it.sauronsoftware.cron4j.TaskExecutionContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProcessTask
extends Task {
    private String[] command;
    private String[] envs;
    private File directory;
    private File stdinFile = null;
    private File stdoutFile = null;
    private File stderrFile = null;

    public ProcessTask(String[] stringArray, String[] stringArray2, File file) {
        this.command = stringArray;
        this.envs = stringArray2;
        this.directory = file;
    }

    public ProcessTask(String[] stringArray, String[] stringArray2) {
        this(stringArray, stringArray2, null);
    }

    public ProcessTask(String[] stringArray) {
        this(stringArray, null, null);
    }

    public ProcessTask(String string) {
        this(new String[]{string}, null, null);
    }

    public boolean canBeStopped() {
        return true;
    }

    public String[] getCommand() {
        return this.command;
    }

    public void setCommand(String[] stringArray) {
        this.command = stringArray;
    }

    public String[] getEnvs() {
        return this.envs;
    }

    public void setEnvs(String[] stringArray) {
        this.envs = stringArray;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File file) {
        this.directory = file;
    }

    public File getStdinFile() {
        return this.stdinFile;
    }

    public void setStdinFile(File file) {
        this.stdinFile = file;
    }

    public void setStdoutFile(File file) {
        this.stdoutFile = file;
    }

    public File getStdoutFile() {
        return this.stdoutFile;
    }

    public void setStderrFile(File file) {
        this.stderrFile = file;
    }

    public File getStderrFile() {
        return this.stderrFile;
    }

    public void execute(TaskExecutionContext taskExecutionContext) throws RuntimeException {
        int n;
        StreamBridge streamBridge;
        Process process;
        try {
            process = this.exec();
        }
        catch (IOException iOException) {
            throw new RuntimeException(this.toString() + " cannot be started", iOException);
        }
        InputStream inputStream = this.buildInputStream(this.stdinFile);
        OutputStream outputStream = this.buildOutputStream(this.stdoutFile);
        OutputStream outputStream2 = this.buildOutputStream(this.stderrFile);
        if (inputStream != null) {
            streamBridge = new StreamBridge(inputStream, process.getOutputStream());
            streamBridge.start();
        }
        if (outputStream != null) {
            streamBridge = new StreamBridge(process.getInputStream(), outputStream);
            streamBridge.start();
        }
        if (outputStream2 != null) {
            streamBridge = new StreamBridge(process.getErrorStream(), outputStream2);
            streamBridge.start();
        }
        try {
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            process.destroy();
            throw new RuntimeException(this.toString() + " has been interrupted");
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (outputStream2 != null) {
            try {
                outputStream2.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (n != 0) {
            throw new RuntimeException(this.toString() + " returns with error code " + n);
        }
    }

    private Process exec() throws IOException {
        Process process;
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(this.command, this.envs, this.directory);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            process = runtime.exec(this.command, this.envs);
        }
        return process;
    }

    private InputStream buildInputStream(File file) {
        if (file != null) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private OutputStream buildOutputStream(File file) {
        if (file != null) {
            try {
                return new FileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static String listStrings(String[] stringArray) {
        if (stringArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Task[");
        stringBuffer.append("cmd=");
        stringBuffer.append(ProcessTask.listStrings(this.command));
        stringBuffer.append(", env=");
        stringBuffer.append(ProcessTask.listStrings(this.envs));
        stringBuffer.append(", ");
        stringBuffer.append("dir=");
        stringBuffer.append(this.directory);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

