/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.autodiscover.configuration;

import java.net.URI;
import java.util.List;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.autodiscover.enumeration.AutodiscoverResponseType;
import microsoft.exchange.webservices.data.autodiscover.enumeration.UserSettingName;
import microsoft.exchange.webservices.data.autodiscover.exception.error.AutodiscoverError;
import microsoft.exchange.webservices.data.autodiscover.response.GetUserSettingsResponse;
import microsoft.exchange.webservices.data.core.EwsXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;

@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class ConfigurationSettingsBase {
    private AutodiscoverError error;

    public boolean tryReadCurrentXmlElement(EwsXmlReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase("Error")) {
            this.error = AutodiscoverError.parse(reader);
            return true;
        }
        return false;
    }

    public void loadFromXml(EwsXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.NotSpecified, "Autodiscover");
        reader.readStartElement(XmlNamespace.NotSpecified, "Response");
        do {
            reader.read();
            if (!reader.isStartElement() || this.tryReadCurrentXmlElement(reader)) continue;
            reader.skipCurrentElement();
        } while (!reader.isEndElement(XmlNamespace.NotSpecified, "Response"));
        reader.readEndElement(XmlNamespace.NotSpecified, "Autodiscover");
    }

    public abstract String getNamespace();

    public abstract void makeRedirectionResponse(URI var1);

    public abstract AutodiscoverResponseType getResponseType();

    public abstract String getRedirectTarget();

    public abstract GetUserSettingsResponse convertSettings(String var1, List<UserSettingName> var2);

    public AutodiscoverError getError() {
        return this.error;
    }
}

