/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.autodiscover.configuration.outlook;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.autodiscover.IFunc;
import microsoft.exchange.webservices.data.autodiscover.enumeration.UserSettingName;
import microsoft.exchange.webservices.data.autodiscover.response.GetUserSettingsResponse;
import microsoft.exchange.webservices.data.core.EwsXmlReader;
import microsoft.exchange.webservices.data.core.ILazyMember;
import microsoft.exchange.webservices.data.core.LazyMember;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;

@EditorBrowsable(state=EditorBrowsableState.Never)
final class OutlookUser {
    private static LazyMember<Map<UserSettingName, IFunc<OutlookUser, String>>> converterDictionary = new LazyMember<Map<UserSettingName, IFunc<OutlookUser, String>>>(new ILazyMember<Map<UserSettingName, IFunc<OutlookUser, String>>>(){

        @Override
        public Map<UserSettingName, IFunc<OutlookUser, String>> createInstance() {
            HashMap<UserSettingName, IFunc<OutlookUser, String>> results = new HashMap<UserSettingName, IFunc<OutlookUser, String>>();
            results.put(UserSettingName.UserDisplayName, new IFunc<OutlookUser, String>(){

                @Override
                public String func(OutlookUser arg) {
                    return arg.displayName;
                }
            });
            results.put(UserSettingName.UserDN, new IFunc<OutlookUser, String>(){

                @Override
                public String func(OutlookUser arg) {
                    return arg.legacyDN;
                }
            });
            results.put(UserSettingName.UserDeploymentId, new IFunc<OutlookUser, String>(){

                @Override
                public String func(OutlookUser arg) {
                    return arg.deploymentId;
                }
            });
            return results;
        }
    });
    private String displayName;
    private String legacyDN;
    private String deploymentId;

    protected OutlookUser() {
    }

    protected void loadFromXml(EwsXmlReader reader) throws Exception {
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals("DisplayName")) {
                this.displayName = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("LegacyDN")) {
                this.legacyDN = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("DeploymentId")) {
                this.deploymentId = reader.readElementValue();
                continue;
            }
            reader.skipCurrentElement();
        } while (!reader.isEndElement(XmlNamespace.NotSpecified, "User"));
    }

    protected void convertToUserSettings(List<UserSettingName> requestedSettings, GetUserSettingsResponse response) {
        HashMap<UserSettingName, IFunc<OutlookUser, String>> converterQuery = new HashMap<UserSettingName, IFunc<OutlookUser, String>>();
        for (Map.Entry<UserSettingName, IFunc<OutlookUser, String>> entry : converterDictionary.getMember().entrySet()) {
            if (!requestedSettings.contains((Object)entry.getKey())) continue;
            converterQuery.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<UserSettingName, IFunc<OutlookUser, String>> entry : converterQuery.entrySet()) {
            String value = entry.getValue().func(this);
            if (value == null || value.isEmpty()) continue;
            response.getSettings().put(entry.getKey(), value);
        }
    }

    protected static Iterable<UserSettingName> getAvailableUserSettings() {
        return converterDictionary.getMember().keySet();
    }
}

