/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import microsoft.exchange.webservices.data.core.EwsXmlReader;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.response.IGetObjectInstanceDelegate;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.util.DateTimeUtils;

public class EwsServiceXmlReader
extends EwsXmlReader {
    private ExchangeService service;

    public EwsServiceXmlReader(InputStream stream, ExchangeService service) throws Exception {
        super(stream);
        this.service = service;
    }

    public Date readElementValueAsDateTime() throws Exception {
        return DateTimeUtils.convertDateTimeStringToDate(this.readElementValue());
    }

    public Date readElementValueAsUnspecifiedDate() throws Exception {
        return DateTimeUtils.convertDateStringToDate(this.readElementValue());
    }

    public Date readElementValueAsUnbiasedDateTimeScopedToServiceTimeZone() throws Exception {
        String date = this.readElementValue();
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            return formatter.parse(date);
        }
        catch (Exception e) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            return formatter.parse(date);
        }
    }

    public Date readElementValueAsDateTime(XmlNamespace xmlNamespace, String localName) throws Exception {
        return DateTimeUtils.convertDateTimeStringToDate(this.readElementValue(xmlNamespace, localName));
    }

    public <TServiceObject extends ServiceObject> List<TServiceObject> readServiceObjectsCollectionFromXml(String collectionXmlElementName, IGetObjectInstanceDelegate<ServiceObject> getObjectInstanceDelegate, boolean clearPropertyBag, PropertySet requestedPropertySet, boolean summaryPropertiesOnly) throws Exception {
        ArrayList<ServiceObject> serviceObjects = new ArrayList<ServiceObject>();
        this.readStartElement(XmlNamespace.Messages, collectionXmlElementName);
        if (!this.isEmptyElement()) {
            do {
                this.read();
                if (!this.isStartElement()) continue;
                ServiceObject serviceObject = getObjectInstanceDelegate.getObjectInstanceDelegate(this.getService(), this.getLocalName());
                if (serviceObject == null) {
                    this.skipCurrentElement();
                    continue;
                }
                if (!this.getLocalName().equals(serviceObject.getXmlElementName())) {
                    throw new ServiceLocalException(String.format("The type of the object in the store (%s) does not match that of the local object (%s).", this.getLocalName(), serviceObject.getXmlElementName()));
                }
                serviceObject.loadFromXml(this, clearPropertyBag, requestedPropertySet, summaryPropertiesOnly);
                serviceObjects.add(serviceObject);
            } while (!this.isEndElement(XmlNamespace.Messages, collectionXmlElementName));
        } else {
            this.read();
        }
        return serviceObjects;
    }

    public ExchangeService getService() {
        return this.service;
    }

    public void setService(ExchangeService service) {
        this.service = service;
    }
}

