/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.definition;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.PropertyBag;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.property.definition.ServiceObjectPropertyDefinition;

public abstract class PropertyDefinition
extends ServiceObjectPropertyDefinition {
    private String xmlElementName;
    private EnumSet<PropertyDefinitionFlags> flags;
    private String name;
    private ExchangeVersion version;

    protected PropertyDefinition(String xmlElementName, String uri, ExchangeVersion version) {
        super(uri);
        this.xmlElementName = xmlElementName;
        this.flags = EnumSet.of(PropertyDefinitionFlags.None);
        this.version = version;
    }

    protected PropertyDefinition(String xmlElementName, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        this.xmlElementName = xmlElementName;
        this.flags = flags;
        this.version = version;
    }

    protected PropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        this(xmlElementName, uri, version);
        this.flags = flags;
    }

    public boolean hasFlag(PropertyDefinitionFlags flag) {
        return this.hasFlag(flag, null);
    }

    public boolean hasFlag(PropertyDefinitionFlags flag, ExchangeVersion version) {
        return this.flags.contains((Object)flag);
    }

    protected void registerAssociatedInternalProperties(List<PropertyDefinition> properties) {
    }

    public List<PropertyDefinition> getAssociatedInternalProperties() {
        ArrayList<PropertyDefinition> properties = new ArrayList<PropertyDefinition>();
        this.registerAssociatedInternalProperties(properties);
        return properties;
    }

    @Override
    public ExchangeVersion getVersion() {
        return this.version;
    }

    public boolean isNullable() {
        return true;
    }

    public abstract void loadPropertyValueFromXml(EwsServiceXmlReader var1, PropertyBag var2) throws Exception;

    public abstract void writePropertyValueToXml(EwsServiceXmlWriter var1, PropertyBag var2, boolean var3) throws Exception;

    public String getXmlElement() {
        return this.xmlElementName;
    }

    public String getName() {
        if (null == this.name || this.name.isEmpty()) {
            ServiceObjectSchema.initializeSchemaPropertyNames();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPrintableName() {
        return this.getName();
    }
}

